/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultSifterCraftingProvider
implements IDataProvider {
    private final SifterRecipeProvider recipeProvider;
    private final SifterLootTableProvider lootTableProvider;
    private final Map<Item, List<SifterMeshDetails>> inputs = new HashMap<Item, List<SifterMeshDetails>>();

    public DefaultSifterCraftingProvider(@NotNull DataGenerator generatorIn, @NotNull LootTableManager lootTableManager) {
        this.inputs.put(Items.field_221582_j, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(71)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151014_N).func_216086_a(25)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221592_t).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221594_v).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221593_u).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221595_w).func_216086_a(1)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(28)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151014_N).func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221592_t).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221594_v).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221593_u).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221595_w).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151172_bF).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151174_bG).func_216086_a(1)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.025f, 0.025f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(3)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151014_N).func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221592_t).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221594_v).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221593_u).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221595_w).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151172_bF).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151174_bG).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151080_bb).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151081_bc).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_185163_cU).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221597_y).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221596_x).func_216086_a(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.035f, 0.035f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151014_N).func_216086_a(25)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221592_t).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221594_v).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221593_u).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221595_w).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151172_bF).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151174_bG).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151080_bb).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151081_bc).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_185163_cU).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221597_y).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221596_x).func_216086_a(5))))));
        this.inputs.put(Items.field_221550_C, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(85)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151145_ak).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h).func_216086_a(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151145_ak).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.025f, 0.025f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(46)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196128_bn).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151045_i).func_216086_a(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.035f, 0.035f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196128_bn).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151045_i).func_216086_a(2))))));
        this.inputs.put(Items.field_221548_A, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221774_cw).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_222065_kN).func_216086_a(2)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(85)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221774_cw).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_222065_kN).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151074_bl).func_216086_a(5)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.025f, 0.025f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221774_cw).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_222065_kN).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151074_bl).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196130_bo).func_216086_a(10)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.035f, 0.035f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221774_cw).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_222065_kN).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151074_bl).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196130_bo).func_216086_a(15))))));
        this.inputs.put(Items.field_221693_cI, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(90)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151128_bU).func_216086_a(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(70)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151128_bU).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151114_aO).func_216086_a(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.025f, 0.025f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151128_bU).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151114_aO).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151065_br).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151064_bs).func_216086_a(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().bonusRolls(0.035f, 0.035f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151128_bU).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151114_aO).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151065_br).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151064_bs).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196184_dx).func_216086_a(5))))));
        this.recipeProvider = new SifterRecipeProvider(generatorIn, lootTableManager);
        this.lootTableProvider = new SifterLootTableProvider(generatorIn);
    }

    @NotNull
    public String func_200397_b() {
        return "SifterCraftingProvider";
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        this.recipeProvider.func_200398_a(cache);
        this.lootTableProvider.func_200398_a(cache);
    }

    private static class SifterMeshDetails {
        private final String name;
        private final Item mesh;
        private final int minBuildingLevel;
        private final LootTable.Builder lootTable;

        public SifterMeshDetails(@NotNull Item mesh, int minBuildingLevel, @NotNull LootTable.Builder lootTable) {
            this.name = mesh.getRegistryName().func_110623_a().replace("sifter_mesh_", "");
            this.mesh = mesh;
            this.minBuildingLevel = minBuildingLevel;
            this.lootTable = lootTable;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Item getMesh() {
            return this.mesh;
        }

        public int getMinBuildingLevel() {
            return this.minBuildingLevel;
        }

        @NotNull
        public LootTable.Builder getLootTable() {
            return this.lootTable;
        }
    }

    private class SifterRecipeProvider
    extends CustomRecipeProvider {
        private final LootTableManager lootTableManager;

        public SifterRecipeProvider(@NotNull DataGenerator generatorIn, LootTableManager lootTableManager) {
            super(generatorIn);
            this.lootTableManager = lootTableManager;
        }

        @NotNull
        public String func_200397_b() {
            return "SifterRecipeProvider";
        }

        @Override
        protected void registerRecipes(@NotNull Consumer<IFinishedRecipe> consumer) {
            for (Map.Entry inputEntry : DefaultSifterCraftingProvider.this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : (List)inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + ((Item)inputEntry.getKey()).getRegistryName().func_110623_a();
                    List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops(this.lootTableManager, mesh.getLootTable().func_216038_b());
                    Stream loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().map(ItemStack::func_77973_b));
                    CustomRecipeProvider.CustomRecipeBuilder.create(ModJobs.SIFTER_ID.func_110623_a() + "_custom", name).inputs(Stream.of(new ItemStorage(new ItemStack((IItemProvider)inputEntry.getKey())), new ItemStorage(new ItemStack((IItemProvider)mesh.getMesh()), true, false)).collect(Collectors.toList())).secondaryOutputs(Stream.concat(Stream.of(mesh.getMesh()), loot).map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + name)).minBuildingLevel(mesh.getMinBuildingLevel()).build(consumer);
                }
            }
        }
    }

    private class SifterLootTableProvider
    extends SimpleLootTableProvider {
        public SifterLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @NotNull
        public String func_200397_b() {
            return "SifterLootTableProvider";
        }

        @Override
        protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
            for (Map.Entry inputEntry : DefaultSifterCraftingProvider.this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : (List)inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + ((Item)inputEntry.getKey()).getRegistryName().func_110623_a();
                    registrar.register(new ResourceLocation("minecolonies", "recipes/" + name), LootParameterSets.field_216266_g, mesh.getLootTable());
                }
            }
        }
    }
}

